require 'rspec'
require 'nokogiri'
require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'
require_relative '../../pages/landing_page'

describe '[VARUT-1641: Select Facility Location - Pre Authorized Page View]
          [VARUT-1755: Facility Selection - Require for first time user]' do

  include DriverUtility
  include DateUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @landing_page = LandingPage.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VARUT-1744|TC#VARUT-1745: Select Facility Location - Pre Authorized Page View ]
           [AC#VARUT-1770|TC#VARUT1771: Facility Selection - Require for first time user]' do

    it "Login" do
      @vts_po.accessVarUtility.access_var_utility(UserAccess7)
      @vts_po.landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@vts_po.landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@vts_po.landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")
    end

    it "Verify pre authorized page - Details" do
      @vts_po.landing.welcome_message_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.facility_location?
      @vts_po.landing.view_settings?

      expect(@vts_po.landing.primary_header).to eq("VAR Utility - Select Facility Location")
      homeWelcomeMessage =  @vts_po.landing.welcome_message.split("\n")
      #for screen reader

      expect(homeWelcomeMessage[1]).to eq( "Welcome SEVEN PROVIDER")

      today = getDateNthDaysAgo(0, "%B %d, %Y")
      expect(homeWelcomeMessage[2]).to eq(today)
      expect(homeWelcomeMessage[3]).to eq("In order to support requests and direct scheduling options in VAR, settings for each facility location under BOSTON HCS VAMC must be individually configured.")

    end

    it "Verify Facility list is sorted and default option displayed for dropdown is 'select institution'" do
      expect(@landing_page.isFacilityListSorted?).to eq(true)
      expect(@landing_page.facility_location_element.selected?('Select:'))
    end

    it "Verify error message is displayed if no facility selected" do
      @landing_page.view_settings
      @landing_page.error_message_displayed_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.error_message_displayed_element.text).to eq("The following errors were found:\nSelect a Facility Location is required")

    end

    it "Verify selecting view settings button for each facility takes user to VAR Utility page - Details" do

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BROCKTON VAMC')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('FRAMINGHAM')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('QUINCY')
      @landing_page.view_settings
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      @driver.back
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      end
  end
end
